	function PLOT_MAGNITUDE_ZW(wT, H)
 
	% 	Plots the magnitude in dB given the frequency response of a digital filter
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB
		
	% 	Author: 		Lars Wanhammar 2007-10-07
	% 	Modified by: 	LW 2008-07-09	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1	 
	% 	Known bugs:		 
	% 	Report bugs to:	Wanhammar@gmail.com
 
	%========================================================	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================
	MAG = H_2_MAG(H);
	plot(wT, MAG,'linewidth',lw); 
	 axis([min(wT) max(wT) max(MAG)-80 max(MAG)])
	ylabel('{|\itW}({\ite^j^\omega^T})|  [dB]','FontName', fn,'FontSize',fs);	
	xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize', fs);
	set(gca,'FontName', fn,'FontSize', fs);
	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};
	xtick(ax,lab);
	grid on;
